@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">PRODUCTOS RETIRADOS POR TIENDA / ALMACEN</h4>
                
            <div class="ui equal width grid">
                <div class="row">
                     <div class="column">

                        <div class="field">
                            <b>Listar productos retirados de : &nbsp;&nbsp;</b>
                            <select class="ui small dropdown" name="id_local">
                                <option value="0">Todas las tiendas y almacenes</option>
                                @foreach($locales as $sucursal)
                                    @if($sucursal->id_local == $id_sucursal)
                                    <option value="{{$sucursal->id_local}}" selected>{{ucwords(mb_strtolower($sucursal->nombre))}} ({{$sucursal->tipo_local->nombre}})</option>
                                    @else
                                    <option value="{{$sucursal->id_local}}">{{ucwords(mb_strtolower($sucursal->nombre))}} ({{$sucursal->tipo_local->nombre}})</option>
                                    @endif
                                @endforeach
                            </select>  
                        </div>
                    </div>
                    {{-- <div class="column export_files" style="text-align: right">
                        <div class="ui icon buttons" >
                            <button class="ui grey basic button" title="Clic para descargar en Excel"><i class="green large file excel outline icon"></i></button>
                            <button class="ui grey basic button" title="Clic para descargar en PDF"><i class="red large file pdf outline icon"></i></button>
                        </div>
                    </div> --}}
                   
                </div>
            </div>    

            <table class="ui celled striped table">
                <thead>
                    <tr>
                        <th class="head_table">N°</th>
                        <th class="head_table">Producto</th>
                        <th class="head_table">Presentacion</th>
                        <th class="head_table">Cantidad Retirada</th>
                        <th class="head_table">Fecha de Retiro</th>
                        <th class="head_table">Ubicacion</th>
                        <th class="head_table">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                   <?php /**/ $i = $data->firstItem() /**/ ?>
                    @foreach ($data as $row)
                    <tr data-table="{{ $row->id_producto }}">
                        <td>{{ $i }}</td>
                        <td>{{ $row->producto->nombre }} {{ $row->producto->descripcion }}</td>
                        <td>{{ $row->producto->tipo_presentacion->nombre }}</td>
                        <td>{{ $row->producto->precio }}</td>
                        
                        <td>{{ round($row->stock) }}</td>
                        <td>{{ $row->local->nombre}}</td>
                        <td>                            
                            <div class="ui mini vertical animated positive button button_info_modal" title="Ver informacion detallada" data-id="{{ $row->id_producto }}" data-idlocal="{{ $row->id_local }}">
                                <div class="hidden content">Info</div>
                                <div class="visible content"><i class="search icon"></i></div>
                            </div>
                      
                        </td>
                    </tr>
                    <?php /**/ $i++ /**/ ?>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="8">
                            @include('layout.includes.pagination')
                        </th>
                    </tr>
                </tfoot>
            </table>

        </div>
    </div>

    <!--start details modal -->
    <div class="ui standard small modal" id="detalles_modal">
        <div class="header">Información del Producto</div>
        <div class="content">
            <div class="description">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="six wide column " style="text-align: right"><b>Codigo de Barras : </b></div>
                        <div class="ten wide column"><span id="_1"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="six wide column " style="text-align: right"><b>Nombre : </b></div>
                        <div class="ten wide column"><span id="_2"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="six wide column " style="text-align: right"><b>Descripción o Marca : </b></div>
                        <div class="ten wide column"><span id="_3"></span></div>
                    </div>
                   <div class="row" style="padding-bottom: 0 !important">
                        <div class="six wide column " style="text-align: right"><b>Tipo de Producto : </b></div>
                        <div class="ten wide column"><span id="_4"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="six wide column " style="text-align: right"><b>Fecha de Vencimiento : </b></div>
                        <div class="ten wide column"><span id="_5"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="six wide column " style="text-align: right"><b>Tipo de Presentacion : </b></div>
                        <div class="ten wide column"><span id="_6"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="six wide column " style="text-align: right"><b>Unidad de Medida : </b></div>
                        <div class="ten wide column"><span id="_7"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="six wide column " style="text-align: right"><b>Situacion de Impuesto : </b></div>
                        <div class="ten wide column"><span id="_8"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="six wide column " style="text-align: right"><b>Tipo de Impuesto: </b></div>
                        <div class="ten wide column"><span id="_9"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="six wide column " style="text-align: right"><b>Valor de Impuesto : </b></div>
                        <div class="ten wide column"><span id="_10"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="six wide column " style="text-align: right"><b>Precio de Venta Unitario: </b></div>
                        <div class="ten wide column"><span id="_11"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="six wide column " style="text-align: right"><b>Precio de Compra Unitario: </b></div>
                        <div class="ten wide column"><span id="_12"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="six wide column " style="text-align: right"><b>Ganancia por Unidad: </b></div>
                        <div class="ten wide column"><span id="_13"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="six wide column " style="text-align: right"><b>Ubicacion del producto: </b></div>
                        <div class="ten wide column"><span id="_14"></span></div>
                    </div>
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="six wide column " style="text-align: right"><b>Stock: </b></div>
                        <div class="ten wide column"><span id="_15"></span></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="actions">
            <div class="ui primary right labeled icon deny button">Cerrar<i class="times icon"></i></div>
        </div>
    </div>
    <!--end details modal -->


@stop


@section('scripts')
    <script src="{{ asset('js/producto/listar_local.js') }}"></script>
@stop


