<?php 

	include("config.php");
	require_once("phpexcel/PHPExcel.php");

	if (PHP_SAPI == 'cli')
    	die('Este archivo solo se puede ver desde un navegador web');
	
	// Se crea el objeto PHPExcel
	$objPHPExcel = new PHPExcel();

	$id_local = $_GET['id_local'];
	$opcion = $_GET['opcion'];

	$conexion = new mysqli($db_host,$db_user,$db_pass,$db_name);
	if (mysqli_connect_errno()) {
	   printf("La conexión con el servidor de base de datos falló: %s\n", mysqli_connect_error());
	   exit();
	}

	if ($opcion == 1) {
		if ($id_local == 0) {
			$consulta = 'SELECT pl.stock as stock, l.nombre as local, l.direccion as direccion, p.* , u.nombre as unidad, t.nombre as presentacion FROM producto_local pl INNER JOIN local l ON pl.id_local=l.id_local INNER JOIN productos p ON pl.id_producto=p.id_producto INNER JOIN tipo_presentacion t ON t.id_tipo_presentacion = p.id_tipo_presentacion INNER JOIN unidad_medida u ON u.id_unidad_medida = p.id_unidad_medida WHERE pl.estado=1 AND p.fecha_vencimiento < DATE(NOW()) ORDER BY p.fecha_vencimiento ASC';
		} else{
			$consulta = 'SELECT pl.stock as stock, l.nombre as local, l.direccion as direccion, p.* , u.nombre as unidad, t.nombre as presentacion FROM producto_local pl INNER JOIN local l ON pl.id_local=l.id_local INNER JOIN productos p ON pl.id_producto=p.id_producto INNER JOIN tipo_presentacion t ON t.id_tipo_presentacion = p.id_tipo_presentacion INNER JOIN unidad_medida u ON u.id_unidad_medida = p.id_unidad_medida WHERE pl.id_local="'.$id_local.'"  AND pl.estado=1 AND p.fecha_vencimiento < DATE(NOW()) ORDER BY p.fecha_vencimiento ASC';
		}	
	}

	if ($opcion == 2) {
		if ($id_local == 0) {
			$consulta = 'SELECT pl.stock as stock, l.nombre as local, l.direccion as direccion, p.* , u.nombre as unidad, t.nombre as presentacion FROM producto_local pl INNER JOIN local l ON pl.id_local=l.id_local INNER JOIN productos p ON pl.id_producto=p.id_producto INNER JOIN tipo_presentacion t ON t.id_tipo_presentacion = p.id_tipo_presentacion INNER JOIN unidad_medida u ON u.id_unidad_medida = p.id_unidad_medida WHERE pl.estado=1 AND p.fecha_vencimiento >= CURDATE() AND p.fecha_vencimiento <= DATE_ADD(CURDATE(), INTERVAL 5 MONTH) ORDER BY p.fecha_vencimiento ASC';
		} else{
			$consulta = 'SELECT pl.stock as stock, l.nombre as local, l.direccion as direccion, p.* , u.nombre as unidad, t.nombre as presentacion FROM producto_local pl INNER JOIN local l ON pl.id_local=l.id_local INNER JOIN productos p ON pl.id_producto=p.id_producto INNER JOIN tipo_presentacion t ON t.id_tipo_presentacion = p.id_tipo_presentacion INNER JOIN unidad_medida u ON u.id_unidad_medida = p.id_unidad_medida WHERE pl.id_local="'.$id_local.'"  AND pl.estado=1 AND p.fecha_vencimiento >= CURDATE() AND p.fecha_vencimiento <= DATE_ADD(CURDATE(), INTERVAL 5 MONTH) ORDER BY p.fecha_vencimiento ASC';
		}
	}

	

	 
	$resultado = $conexion->query($consulta);

	if($resultado->num_rows > 0 ){

		// Propiedades del documento
		$objPHPExcel->getProperties()->setCreator("Seven")
									 ->setLastModifiedBy("Seven")
									 ->setTitle("Reporte de PRODUCTOS VENCIDOS")
									 ->setSubject("Reporte de PRODUCTOS VENCIDOS")
									 ->setDescription("Reporte de PRODUCTOS VENCIDOS")
									 ->setKeywords("office 2010 openxml php")
									 ->setCategory("Archivo con resultado de reporte");
		
		// Combino las celdas desde A1 hasta F1
		$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:H1');
		$objPHPExcel->setActiveSheetIndex(0)
		            ->setCellValue('A1', 'REPORTE DE PRODUCTOS VENCIDOS')
		            ->setCellValue('A2', 'ITEM')
		            ->setCellValue('B2', 'NOMBRE')
		            ->setCellValue('C2', 'MARCA')
					->setCellValue('D2', 'UND MEDIDA')
					->setCellValue('E2', 'TIPO IMPUESTO')
					->setCellValue('F2', 'P. COMPRA S/')
					->setCellValue('G2', 'P. VENTA S/')
					->setCellValue('H2', 'UTILIDAD S/')
					->setCellValue('I2', 'VENCIMIENTO')
					->setCellValue('J2', 'TIPO')
					->setCellValue('K2', 'STOCK')
					->setCellValue('L2', 'UBICACION');
					
		// Fuente de la primera fila en negrita
		$boldArray = array('font' => array('bold' => true,),'alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER));
		$objPHPExcel->getActiveSheet()->getStyle('A1:L2')->applyFromArray($boldArray);

		//Ancho de las columnas
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(8);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(80);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(25);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(25);
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
		$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(50);
	
		$i = 3; //Numero de fila donde se va a comenzar a rellenar
		//$suma = 0;
		$j = 1;
		while ($fila = $resultado->fetch_array()) {
			$objPHPExcel->setActiveSheetIndex(0)
			    ->setCellValue('A'.$i, $j)
			    ->setCellValue('B'.$i, utf8_encode($fila['nombre']))
			    ->setCellValue('C'.$i, utf8_encode($fila['descripcion']))
			    ->setCellValue('D'.$i, utf8_encode($fila['unidad']))
			    ->setCellValue('E'.$i, utf8_encode($fila['situacion_impuesto']))
			    ->setCellValue('F'.$i, $fila['precio_compra'])
			    ->setCellValue('G'.$i, $fila['precio'])
			    ->setCellValue('H'.$i, $fila['utilidad'])
			    ->setCellValue('I'.$i, $fila['fecha_vencimiento'])
			    ->setCellValue('J'.$i, utf8_encode($fila['tipo_producto']))
			    ->setCellValue('K'.$i, ($fila['stock'] > 1000000 ? $fila['stock'] - 1000000 : 'AGOTADO'))
			    ->setCellValue('L'.$i, utf8_encode($fila['local'].' ('.$fila['direccion'].')'));
			$i++;
			$j++;
			//$suma = $suma+$fila['Monto S/'];
		}

		//$objPHPExcel->setActiveSheetIndex(0)->setCellValue('F'.$i, "TOTAL");
		//$objPHPExcel->setActiveSheetIndex(0)->setCellValue('G'.$i, $suma);
		//$objPHPExcel->getActiveSheet()->getStyle('F'.$i)->getFont()->setBold(true);

		$color_style_array = [
		  'font'  => [
		    'color' => ['rgb' => 'FF0000'],
		    'bold' => true,
		  ]
		];

		$objPHPExcel->getActiveSheet()->getStyle('I3:I'.$i)->applyFromArray($color_style_array);
		$objPHPExcel->getActiveSheet()->getStyle('K3:K'.$i)->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('F3:F'.$i)->getNumberFormat()->setFormatCode('0.00');
		$objPHPExcel->getActiveSheet()->getStyle('G3:G'.$i)->getNumberFormat()->setFormatCode('0.00');
		$objPHPExcel->getActiveSheet()->getStyle('H3:H'.$i)->getNumberFormat()->setFormatCode('0.00');

		$i = $i-1;
		$H = "L".$i;
		$rango = "A2:$H";
		$styleArray = array('font' => array( 'name' => 'Arial','size' => 10),
		'borders'=>array('allborders'=>array('style'=> PHPExcel_Style_Border::BORDER_THIN,'color'=>array('argb' => 'FFF')))
		);
		$objPHPExcel->getActiveSheet()->getStyle($rango)->applyFromArray($styleArray);

		// Cambiar el nombre de hoja de cálculo
		$objPHPExcel->getActiveSheet()->setTitle('Reporte de Productos Vencidos');

		// Establecer índice de hoja activa a la primera hoja , por lo que Excel abre esto como la primera hoja
		$objPHPExcel->setActiveSheetIndex(0);

		// Se manda el archivo al navegador web, con el nombre que se indica, en formato 2007
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="Reporte_vencidos.xlsx"');
		header('Cache-Control: max-age=0');
		 
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		$objWriter->save('php://output');
		exit;

	}
	else{
	    print_r('No hay resultados para mostrar');
	}



	






