<?php 

	include("config.php");
	require_once("phpexcel/PHPExcel.php");

	if (PHP_SAPI == 'cli')
    	die('Este archivo solo se puede ver desde un navegador web');
	
	// Se crea el objeto PHPExcel
	$objPHPExcel = new PHPExcel();

	$id_local = $_GET['id_local'];
	$fecha1 = $_GET['fecha1'];
	$fecha2 = $_GET['fecha2'];

	$conexion = new mysqli($db_host,$db_user,$db_pass,$db_name);
	if (mysqli_connect_errno()) {
	   printf("La conexión con el servidor de base de datos falló: %s\n", mysqli_connect_error());
	   exit();
	}

	$consulta = 'SELECT CONCAT("ART", sc.id_producto) as codigo, sc.nombre, sc.codigo_barras, sc.descripcion, sc.unidad, sc.fecha_vencimiento, sc.precio, sc.precio_mayorista, sc. compra, 
						SUM(sc.cantidad_compra) as cant_compra, 
						SUM(sc.precio_compra) as total_compra, 
						SUM(sc.cantidad_venta) as cant_venta, 
						SUM(sc.precio_venta) as total_venta,
						SUM(sc.cantidad_compra)-SUM(sc.cantidad_venta) as saldo, 
						SUM(sc.precio_venta)-SUM(sc.precio_compra) as utilidad, 
						sc.local
					FROM (
						 SELECT p.id_producto, 
						 		p.nombre, 
						 		p.codigo_barras, 
						 		p.descripcion, 
						 		um.nombre as unidad,
						 		p.fecha_vencimiento,
						 		p.precio,
						 		p.precio_mayorista,
						 		p.precio_compra AS compra,
						 		d.cantidad as cantidad_compra, 
						 		d.precio_compra_total as precio_compra, 
						 		0 as cantidad_venta,  
						 		0 as precio_venta,
						 		l.nombre as local
						 FROM detalle_compra d
						 INNER JOIN compras c ON d.id_compra = c.id_compra 
						 INNER JOIN local l ON c.id_local = l.id_local 
						 INNER JOIN productos p ON d.id_producto = p.id_producto 
						 INNER JOIN unidad_medida um ON um.id_unidad_medida = p.id_unidad_medida 
						 WHERE (d.created_at >= "'.$fecha1.' 00:00:00" AND d.created_at <= "'.$fecha2.' 23:59:59") AND c.id_local = '.$id_local.'
						 
						 UNION ALL
						 
						 SELECT p.id_producto, 
						 		p.nombre, 
						 		p.codigo_barras, 
						 		p.descripcion, 
						 		um.nombre as unidad,
						 		p.fecha_vencimiento,
						 		p.precio,
						 		p.precio_mayorista,
						 		p.precio_compra AS compra,
						 		0 as cantidad_compra, 
						 		0 as precio_compra, 
						 		d.cantidad as cantidad_venta, 
						 		d.precio_venta_total as precio_venta,
						 		l.nombre as local
						 FROM detalle_venta d
						 INNER JOIN ventas v ON v.id_venta = d.id_venta 
						 INNER JOIN local l ON v.id_local = l.id_local 
						 INNER JOIN productos p ON d.id_producto = p.id_producto 
						 INNER JOIN unidad_medida um ON um.id_unidad_medida = p.id_unidad_medida 
						 WHERE (d.created_at >= "'.$fecha1.' 00:00:00" AND d.created_at <= "'.$fecha2.' 23:59:59") AND v.id_local = '.$id_local.'
					) as sc GROUP BY sc.id_producto, sc.nombre, sc.codigo_barras, sc.descripcion, sc.unidad, sc.fecha_vencimiento, sc.precio, sc.precio_mayorista, sc. compra, sc.local ORDER BY sc.nombre ASC'; 
	 
	$resultado = $conexion->query($consulta);

	if($resultado->num_rows > 0 ){

		// Propiedades del documento
		$objPHPExcel->getProperties()->setCreator("Seven")
									 ->setLastModifiedBy("Seven")
									 ->setTitle("Reporte SEVEN")
									 ->setSubject("Reporte SEVEN")
									 ->setDescription("Reporte SEVEN")
									 ->setKeywords("office 2010 openxml php")
									 ->setCategory("Archivo con resultado de reporte");
		
		// Combino las celdas desde A1 hasta F1
		$objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:N1');
		$objPHPExcel->setActiveSheetIndex(0)
		            ->setCellValue('A1', 'MOVIMIENTO DE PRODUCTOS DE BOLETAS Y FACTURAS ENTRE : '.$fecha1.' & '.$fecha2)
		            ->setCellValue('A2', 'ITEM')
		            ->setCellValue('B2', 'CODIGO INTERNO')
		            ->setCellValue('C2', 'PRODUCTO')
		            ->setCellValue('D2', 'CODIGO BARRAS')
					->setCellValue('E2', 'MARCA')
					->setCellValue('F2', 'UNIDAD MEDIDA')
					->setCellValue('G2', 'FECHA VENCIMIENTO')
					->setCellValue('H2', 'P. DE VENTA UNITARIO')
					->setCellValue('I2', 'P. DE VENTA POR MAYOR')
					->setCellValue('J2', 'P. DE COMPRA UNITARIO')
					->setCellValue('K2', 'UTILIDAD POR UNIDAD')
					->setCellValue('L2', 'CANTIDAD COMPRADA')
					->setCellValue('M2', 'MONTO INVERTIDO S/')
					->setCellValue('N2', 'CANTIDAD VENDIDA')
					->setCellValue('O2', 'MONTO RECAUDADO S/')
					->setCellValue('P2', 'CANTIDAD SALDO')
					->setCellValue('Q2', 'UTILIDAD GENERADA S/')
					->setCellValue('R2', 'TIENDA O SUCURSAL');
					
		// Fuente de la primera fila en negrita
		$boldArray = array('font' => array('bold' => true,),'alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER));
		$objPHPExcel->getActiveSheet()->getStyle('A1:R2')->applyFromArray($boldArray);


		//Ancho de las columnas
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(8);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(150);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(30);	
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(25);
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(25);

		$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(25);
		$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(25);
		$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(25);

        $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(80);
	
		$i = 3; //Numero de fila donde se va a comenzar a rellenar
		$com = 0;
		$ven = 0;
		$uti = 0;
		$j = 1;
		while ($fila = $resultado->fetch_array()) {
			$objPHPExcel->setActiveSheetIndex(0)
			    ->setCellValue('A'.$i, $j)
			    ->setCellValue('B'.$i, $fila['codigo'])
			    ->setCellValue('C'.$i, utf8_encode($fila['nombre']))
			    ->setCellValue('D'.$i, $fila['codigo_barras'])
			    ->setCellValue('E'.$i, utf8_encode($fila['descripcion']))
			    ->setCellValue('F'.$i, utf8_encode($fila['unidad']))
			    ->setCellValue('G'.$i, $fila['fecha_vencimiento'])

			    ->setCellValue('H'.$i, $fila['precio'])
			    ->setCellValue('I'.$i, $fila['precio_mayorista'])
				->setCellValue('J'.$i, $fila['compra'])
				->setCellValue('K'.$i, $fila['precio']-$fila['compra'])

			    ->setCellValue('L'.$i, $fila['cant_compra'])
			    ->setCellValue('M'.$i, $fila['total_compra'])
			    ->setCellValue('N'.$i, $fila['cant_venta'])
			    ->setCellValue('O'.$i, $fila['total_venta'])
			    ->setCellValue('P'.$i, $fila['saldo'])
			    ->setCellValue('Q'.$i, $fila['utilidad'])
			    ->setCellValue('R'.$i, $fila['local']);
			$i++;
			$j++;
			$com = $com+$fila['total_compra'];
			$ven = $ven+$fila['total_venta'];
			$uti = $uti+$fila['utilidad'];
		}

		$centerArray = array('alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER));
		$objPHPExcel->getActiveSheet()->getStyle('A3:A'.$i)->applyFromArray($centerArray);
		$objPHPExcel->getActiveSheet()->getStyle('B3:B'.$i)->applyFromArray($centerArray);

		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('M'.$i, $com);
		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('O'.$i, $ven);
		$objPHPExcel->setActiveSheetIndex(0)->setCellValue('Q'.$i, $uti);

		$objPHPExcel->getActiveSheet()->getStyle('M'.$i)->applyFromArray($centerArray)->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('O'.$i)->applyFromArray($centerArray)->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('Q'.$i)->applyFromArray($centerArray)->getFont()->setBold(true);

		$objPHPExcel->getActiveSheet()->getStyle('H3:H'.$i)->applyFromArray($centerArray)->getNumberFormat()->setFormatCode('0.00');
		$objPHPExcel->getActiveSheet()->getStyle('I3:I'.$i)->applyFromArray($centerArray)->getNumberFormat()->setFormatCode('0.00');
		$objPHPExcel->getActiveSheet()->getStyle('J3:J'.$i)->applyFromArray($centerArray)->getNumberFormat()->setFormatCode('0.00');
		$objPHPExcel->getActiveSheet()->getStyle('K3:K'.$i)->applyFromArray($centerArray)->getNumberFormat()->setFormatCode('0.00');

		$objPHPExcel->getActiveSheet()->getStyle('M3:M'.$i)->applyFromArray($centerArray)->getNumberFormat()->setFormatCode('0.00');
		$objPHPExcel->getActiveSheet()->getStyle('N3:N'.$i)->applyFromArray($centerArray)->getNumberFormat();
		$objPHPExcel->getActiveSheet()->getStyle('O3:O'.$i)->applyFromArray($centerArray)->getNumberFormat()->setFormatCode('0.00');
		$objPHPExcel->getActiveSheet()->getStyle('P3:P'.$i)->applyFromArray($centerArray)->getNumberFormat();
		$objPHPExcel->getActiveSheet()->getStyle('Q3:Q'.$i)->applyFromArray($centerArray)->getNumberFormat()->setFormatCode('0.00');

		$i = $i-1;
		$H = "R".$i;
		$rango = "A2:$H";
		$styleArray = array('font' => array( 'name' => 'Arial','size' => 10),
		'borders'=>array('allborders'=>array('style'=> PHPExcel_Style_Border::BORDER_THIN,'color'=>array('argb' => 'FFF')))
		);
		$objPHPExcel->getActiveSheet()->getStyle($rango)->applyFromArray($styleArray);

		// Cambiar el nombre de hoja de cálculo
		$objPHPExcel->getActiveSheet()->setTitle('Reporte');

		// Establecer índice de hoja activa a la primera hoja , por lo que Excel abre esto como la primera hoja
		$objPHPExcel->setActiveSheetIndex(0);

		// Se manda el archivo al navegador web, con el nombre que se indica, en formato 2007
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="Reporte_Kardex.xlsx"');
		header('Cache-Control: max-age=0');
		 
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		$objWriter->save('php://output');
		exit;

	}
	else{
	    print_r('No hay resultados para mostrar');
	}








