<?php 
 ob_start();
    header('Content-Type: text/html; charset=UTF-8');
    //require("fpdf/fpdf.php");
    require("fpdf/pdf_js.php");
    require_once("PDF417/vendor/autoload.php");
    use BigFish\PDF417\PDF417;
    use BigFish\PDF417\Renderers\ImageRenderer;
    include ("letras/NumeroALetras.php");
    include ("config.php");

    /******************************************************************************************/
    /* consultas SQL
    /******************************************************************************************/

    $id = $_GET['id_proforma'];

    $mysqli = new mysqli($db_host,$db_user,$db_pass,$db_name);

    //Para obtener los datos de la venta
    $query1 = "SELECT p.*, p.created_at as hora, u.username, l.direccion as direc, l.telefono as telef  FROM proformas p INNER JOIN local l ON p.id_local = l.id_local INNER JOIN usuarios u ON p.id_usuario = u.id_usuario WHERE id_proforma = '".$id."' ";
    $result1 = $mysqli->query($query1);
    $row1 = $result1->fetch_assoc();

    //Para obtener los detalles de la venta
    $query2 = "SELECT * , d.precio as precio_unit  FROM detalle_proforma d INNER JOIN productos p ON d.id_producto = p.id_producto WHERE id_proforma = '".$id."' AND d.estado = 1";
    $result2 = $mysqli->query($query2);

    //Para obtener los datos de la empresa
    $query3 = "SELECT * FROM empresa WHERE id_empresa = '1' ";
    $result3 = $mysqli->query($query3);
    $row3 = $result3->fetch_assoc();

    $query4 = "SELECT sum(monto) as pagos FROM detalle_credito WHERE id_proforma = '".$id."' AND estado = 1";
    $result4 = $mysqli->query($query4);
    $row4 = $result4->fetch_assoc();

    // Variables correspondientes a la factura.
    $RUC        = $row1['numero_documento'];    // RUC.
    $NomRazSoc  = $row1['nombre'];              // Nombre o Razón social.
    $FecEmi     = $row1['fecha_emision'];         // Fecha de emisión.
    $Domicilio  = $row1['direccion'];           // Domicilio.
    $TotGrav    = 0;                            // Total gravado.
    $TotIGV     = 0;                            // Total IGV.
    $TotMonto   = 0;  
    $Saldo      = $row1['saldo'];                               
    $Adelanto   = $row1['adelanto'];                    
    $autoriza   = $row3['autorizacion'];
    $pagina     = $row3['pagina_web'];
    $empresa    = $row3['razon_social'];
    $Pagos      = $row4['pagos'] == null ? '0.00' : number_format($row4['pagos'], 2);  
   
    // TOTALES DE LA FACTURA 
    
    $sub_total = 0;
    $total = 0;
    $igv = 0;
    $desc = 0;
    $ii=0;
    while($row2 = $result2->fetch_assoc())
    {
        $array['detalle'][$ii]['descripcion'] = $row2['nombre']." ".$row2['descripcion']; 
        $array['detalle'][$ii]['cantidad'] = number_format($row2['cantidad'] , 4, ".", ""); 
        $array['detalle'][$ii]['precio'] = number_format($row2['precio_unit'], 4, ".", ""); 
        $array['detalle'][$ii]['descuento'] = number_format($row2['descuento'] , 2, ".", ""); 
        $array['detalle'][$ii]['subtotal'] = number_format($row2['subtotal'] , 2, ".", ""); 
        $ii++;
    }

    $TotMonto = number_format($row1['total'], 2, '.', '');       
 

    /******************************************************************************************/
    /* creamos documento PDF
    /******************************************************************************************/

    $pdf=new PDF('P','cm','Letter');
    $pdf->AliasNbPages();
    $pdf->AddPage();
    $pdf->AddFont('IDAutomationHC39M','','IDAutomationHC39M.php');
    $pdf->AddFont('verdana','','verdana.php');
    $pdf->SetAutoPageBreak(true);
    $pdf->SetMargins(0, 0, 0);
    $pdf->SetLineWidth(0.02);
    $pdf->SetFillColor(0,0,0);
    $pdf->Footer(true);


    function cargarEncabezado($pdf, $row1, $row2, $row3, $Domicilio, $pagina) {

        /******************************************************************************************/
        /* ENCABEZADO
        /******************************************************************************************/

        $pdf->image("../public/img/logo_empresa.jpg", 1.2, 1.2 , 4.2, 1.5); // x , y, ancho, alto
        $pdf->RoundedRect(1, 1, 10, 2.5, 0.2, ''); 

        $pdf->SetTextColor(0,0,150);
        $pdf->SetFont('arial','B',10);
        $pdf->SetXY(5.5,1.5);
        $pdf->MultiCell(5.5, 0.4, utf8_decode($row3['razon_social']), 0, "C", 0);

        
        $pdf->SetTextColor(0,0,0);
        $pdf->SetFont('arial','',7);
        $pdf->SetXY(1,2.9);
        $pdf->MultiCell(10, 0.3, utf8_decode($row1['direc']), 0,'C', 0);

        $pdf->SetXY(1,3.2);
        $pdf->MultiCell(10, 0.3, ""."Telf: ".$row1['telef'], 0,'C', 0);


        $pdf->RoundedRect(12, 1, 8, 2.5, 0.2, ''); 

        $pdf->SetTextColor(170,0,0);
        $pdf->SetFont('arial','',14);
        $pdf->SetXY(12,1.5);
        $pdf->Cell(8, 0.25, "RUC: ".$row3['ruc']."", 0, 1,'C', 0);

        $pdf->SetTextColor(0,0,0);
        $pdf->SetFont('arial','B',18);
        $pdf->SetXY(12,2.6);
        $pdf->Cell(8, 0.25, $row1['tipo'].utf8_decode(" N° ").$row1['id_proforma'], 0, 1,'C', 0); 

        /******************************************************************************************/
        /* DATOS DEL CLIENTE
        /******************************************************************************************/

        $h_titu = $pdf->GetMultiCellHeight(15.3, 0.15, utf8_decode($row1['nombre']) , $border=null, $align='L'); 
        $h_domi = $pdf->GetMultiCellHeight(15.3, 0.15, utf8_decode($Domicilio) , $border=null, $align='L');  

        $pdf->RoundedRect(1, 4, 19, 3.2+$h_titu+$h_domi, 0.2, ''); 

        $pdf->SetTextColor(0,0,0);
        $pdf->SetFont('arial','B',10);


        $pdf->SetXY(1.1,4.2);
        $pdf->Cell(1, 0.35, utf8_decode("Cliente                         :"), 0, 1,'L', 0);

        $pdf->SetXY(1.1,5.4+$h_titu+$h_domi);
        $pdf->Cell(1, 0.35, utf8_decode("RUC / DNI"), 0, 1,'L', 0);
     

        $pdf->SetXY(1.1,4.8+$h_titu);
        $pdf->Cell(1, 0.35, utf8_decode("Dirección                    :"), 0, 1,'L', 0);

        $pdf->SetXY(1.1,6.0+$h_titu+$h_domi);
        $pdf->Cell(1, 0.35, utf8_decode("Fecha de emisión"), 0, 1,'L', 0);

        $pdf->SetXY(1.1,6.6+$h_titu+$h_domi);
        $pdf->Cell(1, 0.35, utf8_decode("Moneda"), 0, 1,'L', 0);


        $pdf->SetTextColor(0,0,0);
        $pdf->SetFont('arial','',10);

        $pdf->SetXY(5.0,4.2);
        $pdf->MultiCell(15.3, 0.35, utf8_decode($row1['nombre']), 0, 'L', 0);

        $pdf->SetXY(5.0,4.8+$h_titu);
        $pdf->MultiCell(15.3, 0.35, utf8_decode($Domicilio), 0, 'L', 0);

        $pdf->SetXY(4.7,5.4+$h_titu+$h_domi);
        $pdf->Cell(1, 0.35, ":  ".utf8_decode($row1['numero_documento']), 0, 1,'L', 0);

        $pdf->SetXY(4.7,6.0+$h_titu+$h_domi);
        $pdf->Cell(1, 0.35, ":  ".date_format(date_create($row1['fecha_emision']), 'd-m-Y')."     Hora : ".date("H:i:s", strtotime($row1['hora'])), 0, 1,'L', 0);

        $pdf->SetXY(4.7,6.6+$h_titu+$h_domi);
        $pdf->Cell(1, 0.35, ":  ".utf8_decode("SOL"), 0, 1,'L', 0);


        /******************************************************************************************/
        /* ENCABEZADO DE PRODUCTOS
        /******************************************************************************************/
        
        $Y = $h_titu+$h_domi;

        $pdf->SetTextColor(0,0,0);
        $pdf->SetFont('arial','B',10);

        $pdf->SetXY(1,$Y+8);
        $pdf->Cell(2.5, 0.5, utf8_decode("Cantidad"), 1, 1,'C', 0);

        $pdf->SetXY(3.5,$Y+8);
        $pdf->Cell(8.6, 0.5, utf8_decode("Descripción"), 1, 1,'C', 0);

        $pdf->SetXY(12.1,$Y+8);
        $pdf->Cell(2.7, 0.5, utf8_decode("Precio"), 1, 1,'C', 0);

        $pdf->SetXY(14.8,$Y+8);
        $pdf->Cell(2.7, 0.5, utf8_decode("Descuento"), 1, 1,'C', 0);

        $pdf->SetXY(17.5,$Y+8);
        $pdf->Cell(2.5, 0.5, utf8_decode("Importe"), 1, 1,'C', 0);

        

        /******************************************************************************************/
        /* PIE DE PAGINA
        /******************************************************************************************/

        $pdf->line(1, 25.8, 20.5, 25.8);

        $pdf->SetTextColor(0,0,0);
        $pdf->SetFont('arial','',9);
        $pdf->SetXY(1,26);
        $pdf->MultiCell(19.5, 0.35, utf8_decode("Comprobante NO VALIDO, reclame su BOLETA o FACTURA \n $pagina \n GRACIAS POR SU PREFERENCIA !!"), 0, 'C'); 

        return $Y;
    }

    $Y2 = cargarEncabezado($pdf, $row1, $row2, $row3, $Domicilio, $pagina);

    
    /******************************************************************************************/
    /* LISTA  DE PRODUCTOS
    /******************************************************************************************/
    
    $Y = $Y2 + 8.5;
    $Y1 = 0;

    for ($i=0; $i < sizeof($array['detalle']) ; $i++) { 

        $pdf->SetFont('arial','', 9);
        
        $h_descrip = $pdf->GetMultiCellHeight(8.6, 0.5, utf8_decode($array['detalle'][$i]['descripcion']), $border=null, $align='L'); 
        
        $pdf->SetXY(1,$Y+$Y1);
        $pdf->Cell(2.5, $h_descrip, utf8_decode($array['detalle'][$i]['cantidad']), 1, 1,'C', 0);

        $pdf->SetXY(3.5,$Y+$Y1);
        $pdf->MultiCell(8.6, 0.5, utf8_decode($array['detalle'][$i]['descripcion']) , 1, "L", 0);
        
        $pdf->SetXY(12.1,$Y+$Y1);
        $pdf->Cell(2.7, $h_descrip, $array['detalle'][$i]['precio'] , 1, 1,'R', 0);

        $pdf->SetXY(14.8,$Y+$Y1);
        $pdf->Cell(2.7, $h_descrip, ($array['detalle'][$i]['descuento']==0 ? number_format($array['detalle'][$i]['descuento'],2) : '-'.number_format($array['detalle'][$i]['descuento'],2) ), 1, 1,'R', 0);

        $pdf->SetXY(17.5,$Y+$Y1);
        $pdf->Cell(2.5, $h_descrip, $array['detalle'][$i]['subtotal'], 1, 1,'R', 0);

        $Y1 = $Y1 + $h_descrip;

        if ($Y1>10) {
            $pdf->AddPage();
            $pdf->Footer(true);
            $Y2 = cargarEncabezado($pdf, $row1, $row2, $row3, $Domicilio, $pagina);
            $Y = $Y2 + 8.5;
            $Y1 = 0;
        }
         
    }   

    if (!is_null($Adelanto) && !is_null($Saldo)) {
    
        $pdf->SetFont('arial','',11);
        $pdf->SetXY(9.9,$Y1+10);
        $pdf->Cell(7.6, 0.5, utf8_decode("A Cuenta       S/ "), 1, 1,'R', 0);

        $pdf->SetXY(17.5,$Y1+10);
        $pdf->Cell(2.5, 0.5, number_format($Adelanto,2), 1, 1,'R', 0);

        $pdf->SetXY(9.9,$Y1+10.5);
        $pdf->Cell(7.6, 0.5, utf8_decode("Pago de Letras       S/ "), 1, 1,'R', 0);

        $pdf->SetXY(17.5,$Y1+10.5);
        $pdf->Cell(2.5, 0.5, $Pagos, 1, 1,'R', 0);

        $pdf->SetXY(9.9,$Y1+11);
        $pdf->Cell(7.6, 0.5, utf8_decode("Saldo      S/ "), 1, 1,'R', 0);

        $pdf->SetXY(17.5,$Y1+11);
        $pdf->Cell(2.5, 0.5, number_format($Saldo,2), 1, 1,'R', 0);

    }    

    
    $pdf->SetFont('arial','B',12);
    $pdf->SetXY(9.9,$Y1+11.5);
    $pdf->Cell(7.6, 0.7, utf8_decode("Importe Total       S/ "), 1, 1,'R', 0);

    $pdf->SetXY(17.5,$Y1+11.5);
    $pdf->Cell(2.5, 0.7, number_format($TotMonto,2), 1, 1,'R', 0);

    // nombre de usuario
    $pdf->SetFont('helvetica','BI',8);
    $pdf->SetXY(1,$Y1+11.5);
    $pdf->MultiCell(5, 0.4,"USUARIO : ".$row1['username'] , 0, 'L');


    //Monto en letras
    $letras = NumeroALetras::convertir($TotMonto, 'soles', 'centimos');
    $pdf->SetXY(1,$Y1+12.5);
    $pdf->MultiCell(19, 0.4,"SON : ".$letras ."  SOLES" , 0, 'L');



    //Observacion
    if (!is_null($row1['observacion'])) {
        $pdf->SetFont('helvetica','I',8);
        $pdf->SetXY(1,$Y1+13.5);
        $pdf->MultiCell(19, 0.4,"OBSERVACION : ".utf8_decode($row1['observacion']) , 0, 'L');
    }
    
    //==============================================================================
    
    $pdf->AutoPrint(true);
    $pdf->Output();
    
ob_end_flush(); 