<!DOCTYPE html>
<html lang="ES-es">
	<head>
		<meta charset="UTF-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta http-equiv="cache-control" content="no-cache"/>
		<meta http-equiv="expires" content="0"/>
		<meta http-equiv="pragma" content="no-cache"/>
		<title>Pedidos por Delivery</title>
		<meta name="description" content="Pedido de Productos por Delivery - Seven">
		<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
		<link rel="shortcut icon" href="ico/favicon.ico" type="image/x-icon">
		<link rel="stylesheet" href="css/semantic.css">
		<link rel="stylesheet" href="css/delivery.css">
	</head>
	<body class="pushable" style="overflow :hidden">
        <div class="pusher" id="pusher" style="visibility:hidden">
            <!-- Start Login Page -->
            <section id="wrap">
                <div class="container">
                    <p></p>
                    <hr class="slideRight">
                    <p><span id="razon_social_empresa"><span</p>
                    <hr class="slideRight">
                    <p>DIRECCION: <span id="direccion_empresa"></span>  <br> RUC: <span id="ruc_empresa"></span>  - Telefono: <span id="telefono_empresa"></span>   </p>
                </div>
                <div class="ui hidden divider"></div>	
                <div class="ui middle aligned center aligned grid">
                    <div class="column">
                        <div class="sixteen wide tablet sixteen wide computer column ">
                            <div class="ui segment">
                                <h4 class="ui dividing header teal centered">Pide tus productos por Delivery</h4> 
                                <form class="ui form" id="frmNuevo" autocomplete="off"> 
                                    <input type="hidden" id="latitud" name="latitud">
                                    <input type="hidden" id="longitud" name="longitud">
                                    <input type="hidden" name="total_venta" class="total_venta">
                                    <br>
                                    <div class="four fields">
                                        <div class="three wide field">
                                            <div class="ui fluid large white label" id="tipo_doc">RUC / DNI</div>
                                        </div>
                                        <div class="four wide field">
                                            <div class="ui action small input" >
                                                <input type="text" id="numero_documento" name="numero_documento"  placeholder="Buscar..." maxlength="11">
                                                <div class="ui icon button" id="loading_doc" title="Ingrese su numero de documento y haga clic para Consultar"><i class="search icon"></i>&nbsp;Consultar</div>
                                            </div>
                                        </div>
                                        <div class="inline fields"> 
                                            <div class="two wide field"></div>
                                            <div class="field">
                                                <div class="ui radio checkbox">
                                                    <input type="radio" name="metodo_pago" checked="checked" value="EFECTIVO">
                                                    <label>PAGO EN EFECTIVO</label>
                                                </div>
                                            </div>
                                        </div> 
                                        <div class="inline fields"> 
                                            <div class="field">
                                                <div class="ui radio checkbox">
                                                    <input type="radio" name="metodo_pago" value="TARJETA">
                                                    <label>PAGO CON TARJETA</label>
                                                </div>
                                            </div> 
                                        </div> 
                                    </div>
                                    <div class="three fields">
                                        <div class="three wide field">
                                            <div class="ui fluid large white label">Ingrese su Nombre</div>
                                        </div>
                                        <div class="eleven wide field">
                                            <div class="ui small input">
                                                <input type="text"  name="nombre" id="nombre_cliente"    maxlength="200" oninput="$.upperCase(this)">
                                            </div>  
                                        </div>
                                    </div>
                                    <div class="three fields">
                                        <div class="three wide field">
                                            <div class="ui fluid large white label">Ingrese su Direccion</div>
                                        </div>
                                        <div class="eleven wide field">
                                            <div class="ui small input">
                                                <input type="text" name="direccion" id="direccion"  maxlength="200" oninput="$.upperCase(this)">
                                            </div>  
                                        </div>
                                        <div class="two wide field">
                                            <div class="ui fluid small green button btn_modal_mapa" title="Seleccione su ubicacion en el mapa"><i class="search icon"></i>VER MAPA</div>
                                        </div>
                                    </div>
                                    <div class="three fields">
                                        <div class="three wide field">
                                            <div class="ui fluid large white label">Correo Electronico</div>
                                        </div>
                                        <div class="six wide field">
                                            <div class="ui small input">
                                                <input type="text" name="email"  maxlength="200" oninput="$.lowerCase(this)">
                                            </div>  
                                        </div>
                                        <div class="two wide field">
                                            <div class="ui fluid large white label">Telefono</div>
                                        </div>
                                        <div class="three wide field">
                                            <div class="ui small input">
                                                <input type="text" name="telefono"  maxlength="200" oninput="$.upperCase(this)" placeholder="987654321">
                                            </div>  
                                        </div>
                                    </div>
                                    <div class="three fields">
                                        <div class="three wide field">
                                            <div class="ui fluid large white label">Observacion</div>
                                        </div>
                                        <div class="eleven wide field">
                                            <div class="ui small input">
                                                <input type="text" name="observacion"  maxlength="200" oninput="$.upperCase(this)" placeholder="Ingrese alguna observacion adicional">
                                            </div>  
                                        </div>
                                    </div>
                                    <br>
                                    <div class="four fields">
                                        <div class="three wide field">
                                            <div class="ui fluid large white label">Buscar producto</div>
                                        </div>
                                        <div class="eleven wide field">
                                            <select class="ui search selection " name="id_prod"></select> 
                                        </div>
                                        <div class="two wide field">
                                            <div class="ui fluid small green button btn_buscar_producto" title="Clic para ver lista de productos"><i class="search icon"></i>VER TODO</div>
                                        </div>
                                    </div>
                                    <br>
                                    <table class="ui celled table">
                                        <thead>
                                            <tr>
                                                <th class="center aligned">Producto</th>
                                                <th class="center aligned" data-tooltip="Cantidad a comprar" data-position="top center" data-inverted="">Cantidad</th>
                                                <th class="center aligned" data-tooltip="Precio de venta unitario" data-position="top center" data-inverted="">Precio S/</th>
                                                <th class="center aligned">Subtotal S/</th>
                                                <th class="center aligned">Acción</th>
                                            </tr>
                                        </thead>
                                        <tbody id="tbody"></tbody>
                                    </table>
                                    <div class="form_footer" style="text-align: left !important;">
                                        <div class="ui right floated labeled small input" >
                                            <label class="ui brown label">TOTAL  S/</label>
                                            <input type="text" class="total_venta" id="total_venta" size="5" readonly style="width: 0%">
                                        </div> 
                                        <div class="ui right floated primary button btn_registrar"><i class="check icon"></i>PEDIR</div>
                                    </div>
                                </form>
                            </div>
                        </div>

                        <!--start register modal -->
                        <div class="ui small basic modal" id="register_modal">
                            <div class="ui icon header"><i class="circular inverted white dollar sign icon"></i>Pedir Productos</div>
                            <div class="content" style="text-align: center; font-size: 16px">
                            <p>¿Desea pedir estos productos por delivery?</p>
                            </div>
                            <div class="actions">
                                <div class="ui red basic cancel inverted button" title="Haga clic para cancelar"><i class="remove icon"></i>Cancelar</div>
                                <div class="ui green ok inverted button" title="Haga clic para confirmar"> <i class="paper plane icon"></i>Confirmar</div>
                            </div>
                        </div>
                        <!--end register modal -->

                        <!--start buscar producto modal -->
                        <div class="ui standard large modal" id="buscar_producto_modal">
                            <div class="header">Buscar Productos</div>
                            <div class="scrolling content">
                                <div class="ui disabled inverted dimmer" id="loader_busqueda">
                                    <div class="ui text loader">Procesando...</div>
                                </div>
                                <div class="ui action small input"  autocomplete="off">
                                    <input type="text" id="buscar_producto" name="buscar_producto" placeholder="Producto a buscar...">
                                    <div class="ui icon button" id="btn_buscar_prod" title="Clic para buscar"><i class="search icon"></i></div>
                                </div> 
                                <table class="ui celled striped table" id="tabla_productos">
                                    <thead>
                                        <tr>
                                            <th class="head_table">N°</th>
                                            <th class="head_table">Descripcion del Producto</th>
                                            <th class="head_table">Precio S/</th>
                                            <th class="head_table">Stock</th>
                                            <th class="head_table">Imagen</th>
                                            <th class="head_table">Añadir a lista</th>
                                        </tr>
                                    </thead>
                                    <tbody id="tbody_productos"></tbody>
                                </table>
                            </div>
                            <div class="actions" >
                                <div class="ui left floated red right labeled icon deny button" style="margin-bottom: 1em">Cerrar<i class="times icon"></i></div>
                            </div>
                        </div>
                        <!--end buscar producto modal -->

                        <!--start buscar MAPA modal -->
                        <div class="ui standard large modal" id="mapa_modal">
                            <i class="close icon"></i>
                            <div class="header"><h3>Haga click en el mapa para indicar su domicilio de envio</h3></div>
                            <div class="scrolling content" style="height: 500px;">
                            <div id="map" ><!-- carga api google maps --></div>
                            </div>
                            <div class="actions" >
                                <div class="ui right floated primary deny  button" style="margin-bottom: 1em"><i class="check icon"></i>Listo</div>
                            </div>
                        </div>
                        <!--end buscar MAPA modal -->

                        <!--start imagen modal -->
                        <div class="ui standard mini modal" id="imagen_modal">
                            <div class="header" id="nombre_producto"></div>
                            <div class="scrolling content" >
                                <img class="medium ui image" style="height: 300px; margin:auto;" id="img_producto" src="">
                            </div>
                            <div class="actions" >
                                <div class="ui left floated red right labeled icon button btn_close_modal_imagen" style="margin-bottom: 1em">Cerrar<i class="times icon"></i></div>
                                <div class="ui right floated green button" style="margin-bottom: 1em">S/. <span id="precio_producto"></span></div>
                            </div>
                        </div>
                        <!--end imagen modal -->

                        <!--start imagen modal -->
                        <div class="ui standard mini modal" id="imagen_modal_2">
                            <div class="header" id="nombre_producto_2"></div>
                            <div class="scrolling content" >
                                <img class="medium ui image" style="height: 300px; margin:auto;" id="img_producto_2" src="">
                            </div>
                            <div class="actions" >
                                <div class="ui left floated red right labeled icon deny button" style="margin-bottom: 1em">Cerrar<i class="times icon"></i></div>
                                <div class="ui right floated green button" style="margin-bottom: 1em">S/. <span id="precio_producto_2"></span></div>
                            </div>
                        </div>
                        <!--end imagen modal -->

                    </div>
                </div>
                <footer>
                    <br>
                    <div id="copy">©&nbsp;&nbsp;<a href="http://soft.pe" target="_blank" rel="noopener noreferrer">Seven</a>&nbsp;&nbsp;|&nbsp; <?php echo date("Y"); ?></div>
                    <br>
                </footer>
            </section>
            <!-- End Login Page -->
        </div>

         <!--start page loader-->
         <div id="loader">
            <div class="ui active dimmer" style="position: fixed;">
                <div class="ui big text loader ">Cargando...</div>
            </div>
        </div>
        <!--end page loader-->

        <!--start ajax loader-->
        <div class="ui disabled inverted dimmer ajax" id="ajax_loader" style="position: fixed;">
            <div class="ui large loader"></div>
        </div>
        <!--end ajax loader-->   
		<script src="js/jquery-3.3.1.min.js"></script>
		<script src="js/semantic.min.js"></script>
		<script src="js/sweetalert.min.js"></script>
		<script src="js/jquery.redirect.js"></script> 
        <script src="js/axios.min.js"></script> 
        <script src="js/helpers.js"></script>
        <!-- <script src="js/delivery.js"></script> -->
        <script src="js/main.min.js"></script>
        <script type="text/javascript">
            getDatosLocal() 
            getDatosEmpresa()
            getProductos()
        </script>
		<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCEe4jiCxBqOF-mjTVYjxejdTEjWCev8I0&language=es&region=PE"></script> 
        <script type="text/javascript">
            google.maps.event.addDomListener(window, 'load', load_map);
        </script>
        <script type="text/javascript">
            $(window).on('load', function (){
                $('#loader').fadeOut(1000,function() { 
                    $(this).remove();
                    $('body').css('overflow','auto'); 
                    $('#pusher').css('visibility','visible'); 
                    $('#sidebar').css('visibility','visible'); 
                }); 
            });
        </script>
	</body>
</html>