<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBajasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bajas', function (Blueprint $table) {
            $table->integer('id_baja')->autoIncrement();
            $table->integer('id_usuario')->nullable();
            $table->integer('id_local')->nullable();
            $table->integer('id_venta')->nullable();
            $table->integer('id_nota')->nullable();
            $table->integer('id_tipo_comprobante')->nullable(); //01 factura | 03 boleta | 07 nc | 08 nd
            $table->string('nombre_baja', 30)->nullable(); //RA-20180714-1
            $table->date('fecha_emision')->nullable();
            $table->date('fecha_referencia')->nullable();
            $table->string('serie', 5)->nullable(); 
            $table->integer('numero')->nullable();
            $table->string('motivo', 200)->nullable(); 
            $table->string('estado_envio', 15)->nullable(); // ACEPTADO, NO ENVIADO, RECHAZADO
            $table->string('mensaje_envio', 500)->nullable();
            $table->tinyInteger('estado')->default('1');
            $table->timestamps();

            $table->foreign('id_usuario')->references('id_usuario')->on('usuarios'); 
            $table->foreign('id_local')->references('id_local')->on('local');  
            $table->foreign('id_venta')->references('id_venta')->on('ventas');   
            $table->foreign('id_nota')->references('id_nota')->on('notas');  
            $table->foreign('id_tipo_comprobante')->references('id_tipo_comprobante')->on('tipo_comprobante');           
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bajas');
    }
}
