<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Traslado extends Model
{
    protected $table = 'traslados';
    protected $primaryKey = 'id_traslado';

    protected $fillable = [
        'id_traslado', 'id_local_origen','id_local_destino', 'id_usuario', 'descripcion', 'flete',  'estado'
    ];

    public function local_origen()
    {
        return $this->belongsTo('App\Models\Local', 'id_local_origen');
    }
    public function local_destino()
    {
        return $this->belongsTo('App\Models\Local', 'id_local_destino');
    }
    public function usuario()
    {
        return $this->belongsTo('App\Models\Usuario', 'id_usuario');
    }
}
