<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Auth;
use App\Models\Egreso;
use App\Models\Local;


class EgresoController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:usuario');
    }
    
	public function nuevo()
    {
	 	$data = [
            'local' => Local::where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->first(), 
        ];
        return view('egreso.nuevo', $data); 
	}

	public function listar()
	{
		$res = Egreso::with(['local','usuario'])->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->paginate(20);    
        return view('egreso.listar', [ 'data' => $res ]); 
	}

	public function registrar(Request $request)
    {
        if ($request->ajax())
        {    
            $request->request->add(['id_usuario' => Auth::guard("usuario")->user()->id_usuario]); 
            $res = Egreso::create($request->all());
            
            $res ? $res['message'] = 'success' : $res['message'] = 'error';

            return response()->json($res); 
        }
	}

	public function detalles($id)
    {
        $data = Egreso::with(['local','usuario'])->where(['id_egreso' => $id , 'estado' => 1])->first();    
        return view('egreso.detalles', [
            'data' => $data
        ]); 
    }

    public function anular(Request $request)
    {
        if ($request->ajax())
        {
            $data = Egreso::find($request->id_egreso);
            $data->estado  = 0; 
            $data->id_usuario = Auth::guard("usuario")->user()->id_usuario;
            
            $res  = $data->save();

            return response()->json($res ? ['message' => 'success'] : ['message' => 'error']);  
        }
    }


}
